/*
* Copyright 2002 by CyberXpert, Inc.
* All rights reserved. No part of this code, logic or concept may be used in any other applications.
* This module is automatically generated by LibOutreach server.
* Please do not change this code. Any change will result in unexpected program behaviour.
*/

# ifndef WRAPPER_SUPPORT_HXX
# define WRAPPER_SUPPORT_HXX

#if defined (WIN32)

#include <winsock.h>
#include <process.h>
#include <time.h>

#define getpid() _getpid()
#define sleep(x) Sleep(x * 1000)

#else //inclusion - Linux/Solaris specific

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <dlfcn.h>
#include <pthread.h>

#ifdef USE_PVM
#include <pvm3.h>
#endif

#include <vector>
using namespace std;

#include<string>
using namespace std;

#define closesocket close

#endif 

#include "libserver_stub.hxx"
#define MAX_FUNCTION_KEY_SIZE    512    // this values is also defined in fserver_defines.hxx, don't change.
#define MAX_LINE_SIZE            1024


#define SSCALAR 	1
#define STRUCTURE 2
#define TSCALAR	3

typedef char *cybx_string;

// Function declarations.

#define TEST_SOCKET(X) { \
	int sd;                 \
   sd = socket (AF_INET, SOCK_STREAM, 0); \
   fprintf (stderr, "%s TEST SOCKETET = %d\n", X, sd);   \
   close (sd); \
}

enum DataServiceType { SOCKET_SERVICE, PVM_PROXY_SERVICE, PVM_SLAVE_SERVICE };

class DataExchange;
typedef int (*REMFUN) (DataExchange * );

class CallbackInfo {
   public :
      char        	module_name [MAX_FUNCTION_KEY_SIZE];
      char        	function_key [MAX_FUNCTION_KEY_SIZE];
      char        	pvm_key [MAX_FUNCTION_KEY_SIZE];
		unsigned int 	call_count;			

      sockaddr_in ClientAddr;
      int         port;
      int         execution_type;
		int			return_type;

		CallbackInfo() {
			return_type = STRUCTURE;
		}
};


class DataExchange {
	char unit_data [MAX_LINE_SIZE];
	int  sd;
	CallbackInfo cinfo;
	pthread_t    thread_id;

	DataServiceType data_service_type;
	int pvm_task_id;
	int pvm_msg_tag;
	static int msg_tag;			// <<- msg tag generator	
	static unsigned short counter;

	void 				*thread_status_node;

	public :

		DataExchange ();

		DataServiceType GetDataServiceType () {
			return data_service_type;
		}

		DataServiceType SetDataServiceType (DataServiceType _data_service_type) {
			return data_service_type = _data_service_type;
		}

		void SetThreadStatusNode (void *_ptr) {
			thread_status_node = _ptr;
			return;
		}

		void *GetThreadStatusNode () {
			return thread_status_node;
		}

		int SetPvmTaskId (int _pvm_task_id) {
			pvm_task_id = _pvm_task_id;	
			return pvm_task_id;
		}	
		int SetPvmMsgTag (int _pvm_msg_tag) {
			pvm_msg_tag = _pvm_msg_tag;
			return pvm_msg_tag;
		}
		int GetNewPvmMsgTag ();

		int PvmCallStart (const char *function_name);

#ifdef USE_PVM
		int PvmSend (const char *msg);
		const char *PvmReceive ();
#endif

		REMFUN ptr;
		#if !defined (WIN32)
 		pthread_mutex_t mut;
 		pthread_cond_t cond;
		#endif

		int close_connection () {
			if (sd != 0) {
				#if defined (WIN32)
					closesocket(sd);
				#else
 					close (sd);
				#endif
				sd = 0;
			} 
			return 1;
 		}

		void SetSd ( int _sd ) {
			sd = _sd;
		}

		void SetRBridgePort ( int _port ) {
			// printf ("RBridge port is set to %d\n", _port);
			cinfo.port = _port;
		}

		void SetClientAddr ( sockaddr_in _addr ) {
			cinfo.ClientAddr = _addr;
		}

		void SetExecutionType (int _execution_type) {
			cinfo.execution_type = _execution_type;
		}

		int SetScalarStream () ;
		int EndScalarStream ();

		int SetScalarThread ();

		void SetModuleName (char *_module_name) {
			strcpy (cinfo.module_name, _module_name);
		}

		void SetFunctionKey (char * _module_name = NULL) {
			if (_module_name == NULL) {
				_module_name = cinfo.module_name;
			}
#if defined(WIN32)
			thread_id = GetCurrentThreadId ();
			sprintf (cinfo.function_key, "%s_%u_%u_%lu", _module_name, ++counter, getpid(), GetCurrentThreadId());
#else
			thread_id = pthread_self();
			sprintf (cinfo.function_key, "%s_%u_%u_%lu", _module_name, ++counter, getpid(), pthread_self());
#endif
		}

		pthread_t GetThreadId () {
			return thread_id;
		}

		void SetPVMKey (char *_pvm_key) {
			if (_pvm_key) {
				strcpy (cinfo.pvm_key, _pvm_key);
			}
		}

		const char *GetFunctionKey() {
			return cinfo.function_key;
		}

		const char *GetPVMKey() {
			return cinfo.pvm_key;
		}

		void SwapKeys () {
			char temp [MAX_FUNCTION_KEY_SIZE];
			strcpy (temp, cinfo.function_key);
			strcpy (cinfo.function_key, cinfo.pvm_key);
			strcpy (cinfo.pvm_key, temp);
		}

		const char *GetModuleName () {
			return cinfo.module_name;
		}

		int GetReturnType () {
			return cinfo.return_type;
		}

		char *receive_data ( int = 1); 
		int  send_data ( int = 1);
		inline char *get_buffer ();

		int send_data (const char *value, int ack = 1);

		int done_with_arguments ();
		int done_with_result ();

		int make_connection ( int );
		int break_connection (int );
};

int receive_and_unpack (DataExchange *, int &, int dimension = 0);
int receive_and_unpack (DataExchange *, long &, int dimension = 0);
int receive_and_unpack (DataExchange *, float &, int dimension = 0);
int receive_and_unpack (DataExchange *, double &, int dimension = 0);
int receive_and_unpack (DataExchange *, char *&, int dimension = 0);
int receive_and_unpack (DataExchange *, string &, int dimension = 0);

#if 0 && defined(SOLARIS) && !defined(GCC)
int receive_and_unpack (DataExchange *de, cybx_string &input, int dimension = 0) {
	char *ptr = input;
	return receive_and_unpack (de, ptr, dimension);
}
#endif

int pack_and_send (DataExchange *, const int &, int dimension = 0);
int pack_and_send (DataExchange *, const long &, int dimension = 0);
int pack_and_send (DataExchange *, const float &, int dimension = 0);
int pack_and_send (DataExchange *, const double &, int dimension = 0);
int pack_and_send (DataExchange *, const char *&, int dimension = 0);
int pack_and_send (DataExchange *, const string &, int dimension = 0);

template <class T>
int receive_and_unpack (DataExchange *de, T *&result, int dimension = 0) {

   int  count; 
   receive_and_unpack (de, count);

	switch (de->GetDataServiceType()) {
		case SOCKET_SERVICE :
#ifdef USE_PVM
      case PVM_SLAVE_SERVICE :
#endif
      {
   		T *result_array = new T [count];
   		for (int i = 0; i < count; i++) {
      		if (dimension == 1)
         		receive_and_unpack (de, result_array [i]);
      		else
         		receive_and_unpack (de, result_array [i], dimension - 1);
   		}

   		result = result_array;
   		break;
		}
#ifdef USE_PVM
		case PVM_PROXY_SERVICE : {
			T result_array [1];
   		for (int i = 0; i < count; i++) {
      		if (dimension == 1)
         		receive_and_unpack (de, result_array[0] );
      		else
         		receive_and_unpack (de, result_array [0], dimension - 1);
   		}
			break;
		}
#endif
	}
	return 1;
}

template <class T>
int receive_and_unpack (DataExchange *de, ResultRange<T> &result, int dimension = 1) {

   int  count;
   receive_and_unpack (de, count);

	switch (de->GetDataServiceType()) {
		case SOCKET_SERVICE :
#ifdef USE_PVM
		case PVM_SLAVE_SERVICE :
#endif
		{
   		T *result_array = new T [count];
   		for (int i = 0; i < count; i++) {
      		if (dimension == 1)
         		receive_and_unpack (de, result_array [i]);
      		else
         		receive_and_unpack (de, result_array [i], dimension - 1);
   		}
			result.Set (count, result_array);
			break;
		}
#ifdef USE_PVM
		case PVM_PROXY_SERVICE : {
			T result_array [1];	  // no need to store the temporary values.
			for (int i = 0; i < count; i++) {
            if (dimension == 1)
               receive_and_unpack (de, result_array[0]);
            else
               receive_and_unpack (de, result_array[0], dimension - 1);
         }
			break;
		}	
#endif
	}
   return 1;
}

template <class T>
int receive_and_unpack (DataExchange *de, vector<T> &result, int dimension = 0) {

   int  count;
   receive_and_unpack (de, count);
	result.resize (count);

   for (int i = 0; i < count; i++) {
   	receive_and_unpack (de, result[i]);
   }
   return 1;
}

template <class T>
int pack_and_send (DataExchange *de, const vector<T> &result, int dimension = 0) {

   int count;
	int status;

	count = result.size();
   status = pack_and_send (de, count);

   for (int i = 0; i < count; i++) {
		if (status)
      	status = pack_and_send (de, result[i]);
   }
   return status;
}

template <class T>
int  pack_and_send (DataExchange *de, Range<T> *&result, int dimension = 1) {
	int status = 1;
	int count;

	switch (de->GetDataServiceType ()) {
		case SOCKET_SERVICE :
#ifdef USE_PVM
		case PVM_SLAVE_SERVICE :
#endif 
		{
			count = result->GetSize ();
			status = pack_and_send (de, count); // Sending the array size.
			break;
		}
#ifdef USE_PVM 
		case PVM_PROXY_SERVICE : {
			const char *temp = de->PvmReceive ();
			count	= atoi (temp);
			status = de->send_data (); // Sending the array size.
			break;
		}
#endif			
	}
	
	if (status < 1) 
		return status;

	if (count == -1 ) {
		count = 0;
		while (1) {
			T value;
			try {
				value = result->GetValue (count);
			} catch (int errcode) {
				count = -1; 
				if (status) {
					status = pack_and_send (de, count);
					return status;
				}
			}

			if (status)
				status = pack_and_send (de, count);

			if (dimension == 1) {
				if (status)
					status = pack_and_send (de, value);
			} else {
				if (status)
					status = pack_and_send (de, value, dimension - 1);
			}

			if (status < 1) 
				return status;

			count ++;
		}
	} else {

		for (int i = 0; i < count; i++) {

			switch (de->GetDataServiceType ()) {
				case SOCKET_SERVICE :
#ifdef USE_PVM
				case PVM_SLAVE_SERVICE :
#endif
				{
					T value = result->GetValue (i);
					if (dimension == 1) {
						if (status)
							status = pack_and_send (de, value);
					} else {
						if (status)
							status = pack_and_send (de, value, dimension - 1);
					}
					break;
				}
#ifdef USE_PVM
				case PVM_PROXY_SERVICE : {
					T value;

					/* no need to store value in value, used just for template instantiation */
					if (dimension == 1) {
						if (status)
							status = pack_and_send (de, value);
					} else {
						if (status)
							status = pack_and_send (de, value, dimension - 1);
					}
					break;	
				}
#endif
			}
			if (status < 1) {
				return status;
			}
		}
	}
	return status;
}


#endif
