
#include <strings.h>
#include "libserver_stub.hxx"

class TextFileTransfer : public Range<char *> {

   char line [1024];
   FILE *fp;

public :

   TextFileTransfer (const char *file_name) {
      fp = fopen (file_name, "r");
      if (fp == NULL) {
         printf ("\n TextFileTransfer::TextFileTransfer() file open error");
      }
   }

   int GetSize () const {
      return -1;
   }

   char **GetValue () {
      return NULL;
   }

   char *GetValue (int i) {
      if (fp == NULL) {
         throw -1;
      }

      char *result = fgets (line, sizeof (line), fp);
      if (result) {
         return line;
      } else {
         throw -1;
      }
   }

   ~TextFileTransfer () {
      if (fp) {
         fclose (fp);
      }
   }
};

TextFileTransfer* get_file (const char* file_name) {

   if (file_name == NULL || strlen (file_name) == 0) {
		return NULL;
   } 

   TextFileTransfer *file = new TextFileTransfer (file_name);
   return file ;
}

