
# include <time.h>
# include <unistd.h>
#include  <string.h>
#include <time.h>
#include <vector>
using namespace std;

#include "../libserver_stub.hxx"

//
// wrapper class for functions returing array of doubles.
//
class DoubleRange : public Range <double> {
      int      size;
      double   *values;

   public :
      DoubleRange (int _size, double _values[]) {
         size   = _size;
         values = _values;
      }

      int GetSize  () const {
         return size;
      }   

		double *GetValue () {
			return values;
		}

      double GetValue (int i) {
         return values [i];   
      }   

      ~DoubleRange () {
			delete [] values;
      }
};

//
// function returns an array 
//
DoubleRange *reverse_range_returns_array (const double *input_range, int range_size) {
   double *output_range = new double [range_size]; 
	double temp;

   for (int i = 0; i < range_size; i++) {
		printf ("Input range value [%d] = %lf\n", i, input_range [range_size  - i - 1]);
      output_range [i] = input_range [range_size  - i - 1];
   }   

   DoubleRange *result_range = new DoubleRange (range_size, output_range);
   return result_range;   
}

//
// function returns values in pass by reference arguemnt.
//
int reverse_range_passby_reference (vector<double> &input_range) {

	int range_size = input_range.size ();
	double temp;

   for (int i = 0; i < range_size / 2; i++) {
		temp = input_range [i];
      input_range [i] = input_range [range_size  - i - 1];
		input_range [range_size  - i - 1] = temp;
   }

	// got to return something...
   return range_size;
}


//
// functions returns a single value.
//
double range_average (vector<double> input_range) {
   double average = 0.0;
	int range_size = input_range.size();

   for (int i = 0; i < range_size; i++) {
      average = average + input_range [i];
   }

	range_size = (range_size ? range_size : 1); // avoids divide by zero.
   return (average / range_size);
}

