
#include <iostream>
#include <stdlib.h>
#include <unistd.h>
#include <vector>
using namespace std;

# include "../libserver_stub.hxx"

class PrimeRange : public Range <int> {
	int   		size;
   vector<int> values;

public :

	PrimeRange (vector<int> _values) {
		size 		= _values.size();
      values 	= _values;
	}

	int GetSize  () const {
		return -1;
	}

	int *GetValue  () {
		return NULL;
	}

	int GetValue (int i) {
		if (i < size) {
			return values [i];
		} else {
			throw (-1);
		}
	}

	~PrimeRange () {
	}
};


int isprime (int number) {
	for (int j = 2; j <= number/2; j++) {
		if (number % j == 0) {
			return 0;	
		}
	}
	return 1;
}

int previous_prime (int number) {
	int j ;
	j = number - 1;

	if (number < 0) {
		return 0;
	}

	while (j > 0) {
		if (isprime(j)) {
			return j;
		}
		j = j - 1;
	}
	return j;
}

int next_prime (int number) {
	int j;

	j = number + 1;
	if (number < 0) {
		return 0;
	}
	while (j > 0) {	// return if j overflows.
		if (isprime (j)) {
			return j;
		}	
		j = j + 1;
	}
	return 0;
}

int prime_numbers_vector (int begin, int end, vector<int> &result) {
	int counter = 0, count = 0;

	if (begin < 0 || end < 0 ) {
		return result.size();
	}

	result.clear ();
   for (int j = begin; j <= end; j++) {
		if (isprime (j)) {                
			result.push_back (j);
		}
	}
	return result.size();
}

Range<int> *prime_numbers_range (int begin, int end) { // example for an unknown size array.

	vector <int> vector_result;
	int size = prime_numbers_vector (begin, end, vector_result);

	PrimeRange *range_result = new PrimeRange (vector_result);
	return range_result;
}

int prime_numbers_count (int begin, int end) {
	int count = 0;

	if (begin < 0 || end < 0 || end <= begin) {
		return 0;
	}

	for (int j = begin; j<end; j++) {
		if (isprime(j)) {
			count ++;
		}
	}
	sleep (2);   // <--- substitute for a time hungry calculation.
	return count;
}

int generate_primes (ExcelChannel <int> * obj, int count) {
	int counter = 0;
	int a_number = 1;
	int prime_number;

  	for (int i = 0; i < count; i++) {
     	sleep (2);

		while (a_number > 0 && !isprime (a_number))
			a_number ++;
			
		if (a_number > 0) 
			obj->Send (a_number);

		counter ++;
  	}
   return 1;
}

