/*
* Copyright 2002 by CyberXpert, Inc.
* All rights reserved. No part of this code, logic or concept may be used in any other applications.
* This module is automatically generated by LibOutreach server.
* Please do not change this code. Any change will result in unexpected program behaviour.
*/

#if !defined (LSERVER_STUB_HXX)
#define LSERVER_STUB_HXX

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

template <class T>
class Range {
   public :
      // virtual functions must be defined in the derived classes,
      virtual int GetSize () const = 0;
      virtual T GetValue (int i) = 0;
      virtual T* GetValue () = 0;

		Range () {
			// default constructor.
		}

		// and are not forced to delete.
		virtual ~Range () {
			// fprintf (stderr, "~Range destructor is being called\n");
		};
};

template <class T, int DIMENSION = 1>
class ResultRange : public Range <T> {
	int size;
	int dimension;
	T   *value;

	public :
		ResultRange () {
			size = 0;
			value = NULL;
			dimension = DIMENSION;
		}

		ResultRange (Range<T> *_value) {
			value = _value->GetValue ();
			size  = _value->GetSize ();
			dimension = DIMENSION;
		}

		ResultRange (T *_value, int _size) {
			size  = _size;
			value = _value;
		}

		int GetSize () const {
			return size;
		}

		T GetValue (int i) {
			try {
				if (size == -1 || i < size) {
					return value [i];	
				} else {
					throw (-1);
				}
			} catch (...) {
				throw (-1);
			}
		}

		T *GetValue () {
			return value;
		}

		T *SetValue (T *&_value) {
			value = _value ;
			return value;
		}

		inline int Set (int _size, T *_value) {
			size 	= _size;
			value = _value;
			return size;
		}

		~ResultRange () {
			// fprintf (stderr, "In ResultRange destructor....\n");
			delete []value;
		}
};

//-----------------------

template <class T>
class ExcelChannel {
	public :
      virtual int Send(T &data) = 0;
};

#endif
