# include <stdio.h>
#include <string.h>
#include "../libserver_stub.hxx"

#include <list>
using namespace std;

#include <vector>
using namespace std;

#include <string>
using namespace std;

class Employee {
public:
	string name;
	double basic;
	double allowance;
	double deduction;

	Employee (const char *_name, double _basic, double _allowance, double _deduction) {
		name = _name;	
		basic = _basic;
		allowance = _allowance;
		deduction = _deduction;
	}
	Employee () {
		name = "dummy";
		basic = allowance = deduction = 0;
	}

	void print () {
		fprintf (stderr, "%s %0.2lf %0.2lf %0.2lf\n", name.c_str(), basic, allowance, deduction);
	}
};

// global variable !
list <Employee> employee_db;

void load_default_db () {

	Employee employee_rec; 
	
	employee_rec = Employee ("Alan", 	24000,  5500, 350 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Bob",		25000,  5600, 360 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Charlie",	26000,  5700, 370 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("David",	27000,  5800, 380 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Edward",	28000,  5900, 390 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Frank",	29000,  6000, 400 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Greg",		30000,  6100, 410 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Henry",	31000,  6200, 420 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Irin",		32000,  6300, 430 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Jack",		33000,  6400, 440 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Kelly",	34000,  6500, 450 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Larry",	35000,  6600, 460 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Mary",		36000,  6700, 470 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Nancy",	37000,  6800, 480 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Opra",		38000,  6900, 490 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Peter",	39000,  7000, 500 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Quincy",	40000,  7100, 510 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Rob",		41000,  7200, 520 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Sam",		42000,  7300, 530 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Tracy",	43000,  7400, 540 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Uland",	44000,  7500, 550 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Victor",	45000,  7600, 560 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Wendy",	46000,  7700, 570 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Xavier",	47000,  7800, 580 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Yiti",		49000,  7900, 590 );  employee_db.push_back (employee_rec);
	employee_rec = Employee ("Ziti",		49000,  8000, 600 );  employee_db.push_back (employee_rec);
};


int get_db (vector<Employee> &employees) {
	if (employee_db.size() == 0) {
		load_default_db ();	
	} 
	employees.clear ();
	list<Employee> :: iterator iter;
	iter = employee_db.begin ();
	while (iter != employee_db.end()) {
		employees.push_back (*iter);
		iter ++;
	}
	return employees.size ();
}

int update_db (const vector<Employee> employee_vec) {
	employee_db.clear ();
	for (int i = 0; i < employee_vec.size (); i++) {
		employee_db.push_back (employee_vec [i]);
	}
	return employee_db.size ();
}

#ifdef MAIN
main () {
	vector <Employee> employees;
	get_db (employees);
	for (int i = 0; i < employees.size (); i++) {
		employees[i].print ();
	}
}
#endif
