

# include <time.h>
# include <unistd.h>
#include  <string.h>
#include <time.h>
#include "../libserver_stub.hxx"

//
// wrapper class for functions returing array of doubles.
//
class DoubleRange : public Range <double> {
      int      size;
      double   *values;

   public :
      DoubleRange (int _size, double _values[]) {
         size   = _size;
         values = _values;
      }

      int GetSize  () const {
         return size;
      }

      double *GetValue () {
         return values;
      }

      double GetValue (int i) {
         return values [i];
      }

      ~DoubleRange () {
         delete [] values;
      }
};


//
// example for N -> N
//
DoubleRange *reverse_range (const double *input_range, int range_size) {
   double *output_range = new double [range_size];

   for (int i = 0; i < range_size; i++) {
      output_range [i] = input_range [range_size  - i - 1];
   }

   DoubleRange *result_range = new DoubleRange (range_size, output_range);
   return result_range;
}

DoubleRange *reverse_range_in_thread_mode (int time_gap, const double *input_range, int range_size) {
   double *output_range = new double [range_size];

	sleep (time_gap);
   for (int i = 0; i < range_size; i++) {
      output_range [i] = input_range [range_size  - i - 1];
   }

   DoubleRange *result_range = new DoubleRange (range_size, output_range);
   return result_range;
}

DoubleRange *upper_and_lower_bound (double amount, double variation) {
   double *output_range = new double [2];

	output_range[0] = amount - (amount * variation);	
	output_range[1] = amount + (amount * variation);	
	
   DoubleRange *result_range = new DoubleRange (2, output_range);
   return result_range;
}

//
// example for 1 -> N  (scalar to array)
//
DoubleRange *nearby_numbers (double input_value) {
   double *output_range = new double [5];

   for (int i = 0; i < 5; i ++) {
      output_range[i] = input_value - 2 + i;
   }

   DoubleRange *result_range = new DoubleRange (5, output_range);
   return result_range;
}


//
// example for N -> 1  (array to scalar)
//
double range_average_function (const double* input_range, int range_size) {
   double average = 0;

   for (int i = 0; i < range_size; i++) {
      average = average + input_range [i];
   }

   range_size = (range_size ? range_size : 1); // avoids divide by zero.
   return (average / range_size);
}

//
// example for 1, 1 -> N
//
//
// event notification after completion.
//
double notify_when_done (int time_in_seconds) {
   double rand_result;

   sleep (time_in_seconds);
   rand_result = (double) rand ();
   rand_result = rand_result / 100.0;
   return rand_result;
}

//  STRING manipulation.

//
// wrapper for functions returning array of strings.
//

class Strings : public Range <char *> {
      int   size;
      char  **values;

   public :
      Strings (int _size, char *_values[]) {
         size     = _size;
         values   = _values;
      }

      int GetSize  () const {
         return size;
      }

      char **GetValue () {
         return values;
      }

      char *GetValue (int i) {
         return values [i];
      }

      ~Strings () {
         for (int i = 0; i < size; i ++) {
            delete values [i];
         }
         delete [] values;
      }
};


//
// example for 1 -> N    (scalar to array)
//
Strings *rotate_string (const char *input_string) {
   int string_length = strlen (input_string);
   char **return_array = new char* [string_length];

   for (int i = 0; i < string_length; i++) {
      return_array [i] = new char [string_length + 1];
      strcpy (return_array [i], input_string + i);
      strncat (return_array [i], input_string, i);
   }
   Strings *result = new Strings (string_length, return_array);
   return result;
}

//
// example for N -> 1   (array to scalar)
//
char *concatenate_strings (const char *input_range[], int range_size) {
   char *result_string = (char *) malloc (256);
   int  available = 256;

   strcpy (result_string, "");
   for (int i = 0; i < range_size && available > strlen (input_range [i]); i++) {
      strcat (result_string, input_range [i]);
      available = available - strlen (input_range [i]);
   }
   return result_string;
}

