
# include <time.h>
# include <unistd.h>
#include  <string.h>
#include <time.h>
#include "../libserver_stub.hxx"

//
// wrapper class for functions returing array of doubles.
//
class DoubleRange : public Range <double> {
      int      size;
      double   *values;

   public :
      DoubleRange (int _size, double _values[]) {
         size   = _size;
         values = _values;
      }

      int GetSize () const {
         return size;
      }

      double *GetValue () {
         return values;
      }

      double GetValue (int i) {
         return values [i];
      }

      ~DoubleRange () {
         delete [] values;
      }
};

//
// STREAM routines.
//

//
//  sends 'seconds' after 'delay' second.
//
int show_second (ExcelChannel <int> * obj, int delay_time, int duration) {
	int _loop = (int) (duration / delay_time);

	for (int i = 0; i < _loop; i++) {
		time_t t = time (NULL);
		struct tm * ptr = localtime (&t);
		obj->Send (ptr->tm_sec);
		sleep (delay_time);
	}
	return 1;
}

//
//  sends 'minutes' updates
//
int show_minute (ExcelChannel <int> * obj, int duration) {
	int delay_time;
	time_t t = time (NULL);
	struct tm * ptr = localtime (&t);
	obj->Send(ptr->tm_min);

	delay_time = t % 60;
	sleep (60 - delay_time);

	for (int i = 0; i < duration; i++) {
		t = time (NULL);
		ptr = localtime (&t);

		obj->Send (ptr->tm_min);
		sleep ( 60 );
	}
	return 1;
}

//
//  sends 'hour' after 'delay' second.
//
int show_hour (ExcelChannel <int> * obj, int duration) {
	int delay_time;
	time_t t = time (NULL);
	struct tm * ptr = localtime (&t);

	obj->Send( ptr->tm_hour );
	delay_time = t % 3600;
	sleep (3600 - delay_time);

	for (int i = 0; i < duration; i++) {
		t = time (NULL);
		ptr = localtime (&t);

		obj->Send (ptr->tm_hour);
		sleep (3600);
	}
	return 1;
}

//
//  sends elapsed time after 'delay' second.
//
int show_elapsed (ExcelChannel <long> * obj, int delay_time, int duration) {
	int start_time = time (NULL);

	int _loop = (int) (duration / delay_time);
	for (int i = 0; i < _loop; i++) {
		time_t t = time (NULL);
		long elapsed = t - start_time;
		obj->Send (elapsed);
		sleep (delay_time);
	}
	return 1;
}

//
//  send the clock display as text.
//
int show_time (ExcelChannel <char *> *obj, int delay_time, int duration) {
	static char *time_string  = new char [128];

	int _loop = (int) (duration / delay_time);
	for ( int i = 0; i < _loop; i++ ) {
		time_t t = time (NULL);
		strcpy (time_string, ctime (&t));  strtok (time_string, "\n\r");

		obj->Send (time_string);
		sleep (delay_time);
	}
	return 1;
}

// 
// sends random number array.
//
int jumping_array (ExcelChannel<DoubleRange *> * obj, int delay_time, int duration) {
	
	int _loop = (int) (duration / delay_time);
	time_t seed = time (NULL);

	printf ("Inside jumping array\n");

	srand (seed);
	double * temp_result = new double[5];
	DoubleRange *result = new DoubleRange (5, temp_result);

	for ( int i = 0; i < _loop ; i++ ) {

		temp_result [0] = 1 + (int) (10.0 * rand()/ (RAND_MAX + 1.0));
		temp_result [1] = 1 + (int) (10.0 * rand()/ (RAND_MAX + 1.0));
		temp_result [2] = 1 + (int) (10.0 * rand()/ (RAND_MAX + 1.0));
		temp_result [3] = 1 + (int) (10.0 * rand()/ (RAND_MAX + 1.0));
		temp_result [4] = 1 + (int) (10.0 * rand()/ (RAND_MAX + 1.0));


		obj->Send (result);
		sleep (delay_time);
	}
	printf ("Jumping Over\n");
	delete result;
	return 1;
}
