#include <time.h>
#include <stdio.h>
#include "../libserver_stub.hxx"
#include <pthread.h>
#include <sys/time.h>
#include <string.h>

int performance_thread (double seconds) {
	struct timeval timeout;

	timeout.tv_sec = (int)seconds;
	timeout.tv_usec = (int)((seconds - timeout.tv_sec) * 1000.0);
	select (1, 0, 0, 0, &timeout);

	return 1;
}

int performance_stream (ExcelChannel <int> *obj, int count, double seconds) {
   time_t timestamp;
	struct timeval timeout;

   timestamp = time (NULL);
   fprintf (stderr, "(%lu) count: %d, start time: %s", pthread_self(), count, ctime(&timestamp));

   while (count > 0 ) {

		if (obj)
      	obj->Send (count);

		timeout.tv_sec = (int)seconds;
		timeout.tv_usec = (int)((seconds - timeout.tv_sec) * 1000.0);
		select (1, 0, 0, 0, &timeout);

      count--;
   }

   timestamp = time (NULL);
   fprintf (stderr, "(%lu) completed time: %s", pthread_self(), ctime(&timestamp));

   return 1;
}

