

#include <stdio.h>
#include <unistd.h>
#include "../libserver_stub.hxx"


int diffuse (double *range, int row, int col) {

	int i, j;
	double decay_factor = 0.01;
	double old_value, avg_value;

	for (i = 0; i < row; i++) {
		for (j = 0; j < col; j++) {

			old_value = *(range + i * col + j);
			
			if (i == 0) { 		// top row.
				if (j == 0) {
			 		avg_value =	(	*(range + (i + 1) * col + j) +
															*(range + i * col +  (j + 1))) / 2.0;
				} else if (j == (col - 1)) {
			 		avg_value = 	(	*(range + i * col + (j - 1)) +
															*(range + (i + 1) * col + j) ) / 2.0;
				} else {
			 		avg_value = 	( 	*(range + i * col + (j - 1)) +
														*(range + (i + 1) * col + j) +
														*(range + i * col +  (j + 1))) / 3.0;
				}
			} else if (i == (row - 1)) {	// bottom row.
				if (j == 0) {
			 		avg_value = 	( 	*(range + (i - 1) * col +  j) +
															*(range + i * col +  (j + 1))) / 2.0;
				} else if (j == (col - 1)) {
			 		avg_value = 	( 	*(range + (i - 1) * col +  j) +
															*(range + i * col + (j - 1)) ) / 2.0;
				} else {
			 		avg_value = 	( 	*(range + (i - 1) * col +  j) +
														*(range + i * col + (j - 1)) +
														*(range + i * col +  (j + 1))) / 3.0;
				}
			} else {
				if (j == 0) {
					// left most column.
			 		avg_value = 	( 	*(range + (i - 1) * col +  j) +
														*(range + (i + 1) * col + j) +
														*(range + i * col +  (j + 1))) / 3.0;

				} else if (j == (col-1))  {
					// right-most column
			 		avg_value = 	( 	*(range + (i - 1) * col +  j) +
													*(range + i * col + (j - 1)) +
													*(range + (i + 1) * col + j) ) / 3.0;

				} else {
			 		avg_value = 	( 	*(range + (i - 1) * col +  j) +
													*(range + i * col + (j - 1)) +
													*(range + (i + 1) * col + j) +
													*(range + i * col +  (j + 1))) / 4.0;
				}
			}

			if (avg_value < old_value) {
			 	*(range + i * col + j) = old_value - ((old_value - avg_value) * decay_factor);
			} else {
			 	*(range + i * col + j) = avg_value;
			}

			if (*(range + i * col + j) < 0.001) {
				*(range + i * col + j) = 0;
			}
		}
	}
	return 1;
}


//
// wrapper class for stream sending array of doubles.
//

class DoubleRange : public Range <double> {
      int      size;
      double   *values;

   public :
      DoubleRange (int _size, double _values[]) {
         size   = _size;
         values = _values;
      }

      int GetSize  () const {
         return size;
      }

      double *GetValue () {
         return values;
      }

      double GetValue (int i) {
         return values [i];
      }

      ~DoubleRange () {
         delete [] values;
      }
};

int diffuse_stream (ExcelChannel<DoubleRange *> *ch, double *input_range, int row, int col, int iterations) {

	int size = row * col;
	DoubleRange *result = new DoubleRange (size, input_range);

	while (iterations) {
		iterations--;

		diffuse (input_range, row, col);

		if (ch->Send (result) <= 0) {
			printf ("Error sending data\n");
			return 0;
		}
		sleep (2);
	}
	return 1;
}
