#!/bin/sh

#
# LibServer control script 
# 
# The exit codes returned are:
#	0 - operation completed successfully
#	1 - error 
#
# 	LIBSERVER_BIN_DIR - location of LibServer.exe file.
#	LIBSERVER_LOG_DIR -	location where LibServer can create/dump its output,
#							should have write permission for LibServer.exe.
#	PROTOTYPE_FILES - list of files (with full path information) for 
#							LibServer to read and generate communication wrappers.
#  LIBSERVER_PORT    - Server's port.
#
#
LIBSERVER_BIN_DIR=.
LIBSERVER_LOG_DIR=
LIBSERVER_PORT=9999

MAX_PVM_PROCESSES=0
export MAX_PVM_PROCESSES

PROTOTYPE_FILES="./samples/primes.prototype ./samples/diffusion.prototype ./samples/performance_test.prototype ./samples/samples.prototype ./samples/sample_threads.prototype ./samples/sample_streams.prototype ./samples/udt.prototype ./samples/text_file_transfer.prototype"

# PROTOTYPE_FILES="
# ./samples/prime.prototype
# ./samples/FinancialRecipes/approximated_option_prices.proto
# ./samples/FinancialRecipes/black_scholes.proto
# ./samples/FinancialRecipes/cash_flow.proto
# ./samples/FinancialRecipes/classical_bond_pricing.proto
# ./samples/FinancialRecipes/currency.proto
# ./samples/FinancialRecipes/exotic_options.proto
# ./samples/FinancialRecipes/finite_differential.proto
# ./samples/FinancialRecipes/futures.proto
# ./samples/FinancialRecipes/general_simulation.proto
# ./samples/FinancialRecipes/option_binomial.proto
# ./samples/FinancialRecipes/simulated_option_price.proto
# ./samples/FinancialRecipes/stochastic_process.proto
# "
# LD_LIBRARY_PATH=../FinancialRecipes/Date-funs:$LD_LIBRARY_PATH


#
#
# Resource constraints

EXECUTION_MODEL=PROCESS_PER_USER      # PROCESS_POOL or PROCESS_PER_USER
MAX_PROCESSES=5
MAX_THREADS_PER_PROCESS=512

#
#
if [ "x$LIBSERVER_BIN_DIR" = "x" ]; then
   LIBSERVER_BIN_DIR=.
fi
#
#
if [ "x$LIBSERVER_LOG_DIR" = "x" ]; then
   LIBSERVER_LOG_DIR=./log
fi
#
#
#
	LD_LIBRARY_PATH=$LIBSERVER_BIN_DIR:$LD_LIBRARY_PATH
	PATH=$LIBSERVER_BIN_DIR:$PATH

	PID_FILE=$LIBSERVER_LOG_DIR/libserver.pid
	LIBSERVER="$LIBSERVER_BIN_DIR/LibServer.exe -p $LIBSERVER_PORT"
	LIB_PVM_SERVER="$LIBSERVER_BIN_DIR/pvm/lo_pvm_server.exe"

	export LIBSERVER_LOG_DIR LIBSERVER_BIN_DIR MAX_THREADS_PER_PROCESS PID_FILE
	export PATH LD_LIBRARY_PATH

	export EXECUTION_MODEL MAX_PROCESSES MAX_THREADS_PER_PROCESS
#
# --------------------                              --------------------

ERROR=0
ARGV="$@"

if [ "x$ARGV" = "x" ] ; then 
    ARGS="help"
fi

#for ARG in $@ $ARGS
#do

ARG=$1

    # check for pidfile
    if [ -f $PID_FILE ] ; then
			PID=`cat $PID_FILE`
			if [ "x$PID" != "x" ] && kill -0 $PID 2>/dev/null ; then
	    			STATUS="LibServer (pid $PID) running"
	    			RUNNING=1 
			else
	    			STATUS="LibServer (pid $PID?) not running"
	    			RUNNING=0
			fi
    else
			STATUS="LibServer (no pid file!) not running"
			RUNNING=0
    fi

   case $ARG in
	start)
		if [ $RUNNING -eq 1 ]; then
	    	echo "$0 $ARG: LibServer (pid $PID) already running"
	    	continue
		fi

		echo $LIBSERVER $PROTOTYPE_FILES 
		$LIBSERVER $PROTOTYPE_FILES 
		# >$LIBSERVER_LOG_DIR/libserver_stdout.log 2>$LIBSERVER_LOG_DIR/libserver_stderr.log &

		if [ $? -eq 0 ] ; then
	    	echo "$0 $ARG: LibServer started"
		else
	    	echo "$0 $ARG: LibServer could not be started"
	    	ERROR=3
		fi
	;;

	pvm_start)
		cd   $2
		exec $LIB_PVM_SERVER $PROTOTYPE_FILES
	;;

	 test)
			echo "TESTING............"
			echo "LIBSERVER_BIN_DIR: $LIBSERVER_BIN_DIR"
			echo "LIBSERVER_LOG_DIR: $LIBSERVER_LOG_DIR"
			echo "PROTOTYPE_FILES: $PROTOTYPE_FILES"
			echo "LIBSERVER_PORT   : $LIBSERVER_PORT"
			echo ""
			echo "Executing      : $LIBSERVER"
			$LIBSERVER -t $PROTOTYPE_FILES
	;;
    stop)
		if [ $RUNNING -eq 0 ]; then
	    	echo "$0 $ARG: $STATUS"
	    	continue
		fi
		if kill -1 $PID ; then
	    	echo "$0 $ARG: LibServer stopped"
		else
	    	echo "$0 $ARG: LibServer could not be stopped"
	    	ERROR=4
		fi
	;;
    restart)
		$0 stop
		$0 start
	;;
    *)
	echo "usage: $0 (start|stop|restart|test|help)"
	cat <<EOF

start    - start LibServer
stop     - stop LibServer
restart  - restart LibServer 
test 		- Completeness test (checks modules integrity)
help     - help, these options.

EOF
	ERROR=2
    ;;

    esac

# done

exit $ERROR

# ===============================================================
# Copyright (c) 1999-2000 CyberXpert, Inc. All rights reserved.
#
# please contact support@cyberxpert.com for copyright details. 
#
# ================================================================
#
